float4x4 shadowProjMatrix : register (c0);

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
#if FLOAT == 1
   float  Depth : TEXCOORD0;
#endif      
};

#if FLOAT == 1

 #if BUMP == 1
  VS_OUTPUT vs11_shadowDrawBumpFP (float4 inPos : POSITION)
 #else
  VS_OUTPUT vs11_shadowDrawFP (float4 inPos : POSITION)
 #endif
  
#else 

 #if BUMP == 1
  VS_OUTPUT vs11_shadowDrawBump (float4 inPos : POSITION)
 #else
  VS_OUTPUT vs11_shadowDraw (float4 inPos : POSITION)
 #endif
  
#endif 
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space (view is the light's view):
  Out.Pos = mul (shadowProjMatrix, inPos);

#if FLOAT == 1
  Out.Depth = (Out.Pos.z);
#endif

  return (Out);
}

